using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace MessageBoard {
    /// <summary>
    /// To jest gwny typ Twojej gry.
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat gry
        SpriteFont font;
        string messageString = "";

        // klawisze nacinite wczeniej (ta tablica pocztkowo jest pusta)
        Keys[] oldKeys = new Keys[0];

        public Game1() {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Umoliwia ewentualn inicjalizacj przed uruchomieniem waciwej gry.
        /// W tym miejscu mona odnale wszystkie wymagane zasoby i zaadowa zasoby inne ni graficzne.
        /// related content. Wywoanie metody base.Initialize spowoduje przeszukanie wszystkich komponentw
        /// i ich inicjalizacj.
        /// </summary>
        protected override void Initialize() {
            // TODO: Tutaj naley doda logik inicjalizacji.

            base.Initialize();
        }

        /// <summary>
        /// Metoda LoadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu adujcego tre.
        /// </summary>
        protected override void LoadContent() {
            // Tworzy nowy obiekt klasy SpriteBatch, ktrego mona uywa do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            font = Content.Load<SpriteFont > ("SpriteFont1");
        }

        /// <summary>
        /// Metoda UnloadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu usuwajcego ca tre z pamici.
        /// </summary>
        protected override void UnloadContent() {
            // TODO: Naley usun ca tre, ktr nie zarzdza ContentManager.
        }

        /// <summary>
        /// Umoliwia grze wykonywanie logiki zwizanej z aktualizacj wiata gry,
        /// sprawdzaniem kolizji, pobieraniem danych wejciowych czy odtwarzaniem dwikw.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Update(GameTime gameTime) {
            KeyboardState keyState = Keyboard.GetState();

            // Umoliwia wyjcie z gry po naciniciu klawisza Esc.
            if (keyState.IsKeyDown(Keys.Escape)) {
                this.Exit();
            }

            // aktualnie wcinite klawisze
            Keys[] pressedKeys;
            pressedKeys = keyState.GetPressedKeys();

            // przeszukuje kolejno wszystkie aktualnie wcinite klawisze
            for (int i = 0; i < pressedKeys.Length; i++) {
                // ustawia flag okrelajc, e nie znaleziono klawisza
                bool foundIt = false;

                // przeszukuje kolejno wszystkie poprzednio wcinite klawisze
                for (int j = 0; j < oldKeys.Length; j++) {
                    if (pressedKeys[i] == oldKeys[j]) {
                        // znaleziono klawisz w tablicy wczeniej wcinitych klawiszy
                        foundIt = true;
                    }
                }
                if (foundIt == false) {
                    // skoro sterowanie trafio w to miejsce, nie znaleziono klawisza w tablicy poprzednio wcinitych klawiszy, zatem
                    // naley doda dany klawisz na koniec acucha komunikatu
                    messageString = messageString + pressedKeys[i].ToString();
                }
            }

            // zapamituje aktualnie wcinite klawisze na potrzeby nastpnego wywoania
            oldKeys = pressedKeys;

            base.Update(gameTime);
        }

        /// <summary>
        /// Ta metoda jest wywoywana w momencie, w ktrym gra musi narysowa swj wiat.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Draw(GameTime gameTime) {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            Vector2 messageVector = new Vector2(50, 100);

            spriteBatch.Begin();
            spriteBatch.DrawString(font, messageString, messageVector, Color.White);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}

